<?php
if (!class_exists('ReduxFramework')) {
    return;
}
if (class_exists('ReduxFrameworkPlugin')) {
    remove_action('admin_notices', array(ReduxFrameworkPlugin::instance(), 'admin_notices'));
}

if(class_exists('Newsletter')) {
    $forms = array_filter( (array) get_option( 'newsletter_forms', array() ) );

    $newsletter_forms = array(
        'default' => esc_html__( 'Default Form', 'bixol' )
    );

    if ( $forms )
    {
        $index = 1;
        foreach ( $forms as $key => $form )
        {
            $newsletter_forms[ $key ] = sprintf( esc_html__( 'Form %s', 'bixol' ), $index );
            $index ++;
        }
    }
} else {
    $newsletter_forms = '';
}

$opt_name = bixol_get_opt_name();
$theme = wp_get_theme();

$args = array(
    // TYPICAL -> Change these values as you need/desire
    'opt_name'             => $opt_name,
    // This is where your data is stored in the database and also becomes your global variable name.
    'display_name'         => $theme->get('Name'),
    // Name that appears at the top of your panel
    'display_version'      => $theme->get('Version'),
    // Version that appears at the top of your panel
    'menu_type'            => class_exists('Case_Theme_Core') ? 'submenu' : '',
    //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
    'allow_sub_menu'       => true,
    // Show the sections below the admin menu item or not
    'menu_title'           => esc_html__('Theme Options', 'bixol'),
    'page_title'           => esc_html__('Theme Options', 'bixol'),
    // You will need to generate a Google API key to use this feature.
    // Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
    'google_api_key'       => '',
    // Set it you want google fonts to update weekly. A google_api_key value is required.
    'google_update_weekly' => false,
    // Must be defined to add google fonts to the typography module
    'async_typography'     => false,
    // Use a asynchronous font on the front end or font string
    //'disable_google_fonts_link' => true,                    // Disable this in case you want to create your own google fonts loader
    'admin_bar'            => true,
    // Show the panel pages on the admin bar
    'admin_bar_icon'       => 'dashicons-admin-generic',
    // Choose an icon for the admin bar menu
    'admin_bar_priority'   => 50,
    // Choose an priority for the admin bar menu
    'global_variable'      => '',
    // Set a different name for your global variable other than the opt_name
    'dev_mode'             => true,
    // Show the time the page took to load, etc
    'update_notice'        => true,
    // If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
    'customizer'           => true,
    // Enable basic customizer support
    //'open_expanded'     => true,                    // Allow you to start the panel in an expanded way initially.
    //'disable_save_warn' => true,                    // Disable the save warning when a user changes a field
    'show_options_object' => false,
    // OPTIONAL -> Give you extra features
    'page_priority'        => null,
    // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
    'page_parent'          => class_exists('Case_Theme_Core') ? $theme->get('TextDomain') : '',
    // For a full list of options, visit: //codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
    'page_permissions'     => 'manage_options',
    // Permissions needed to access the options panel.
    'menu_icon'            => '',
    // Specify a custom URL to an icon
    'last_tab'             => '',
    // Force your panel to always open to a specific tab (by id)
    'page_icon'            => 'icon-themes',
    // Icon displayed in the admin panel next to your menu_title
    'page_slug'            => 'theme-options',
    // Page slug used to denote the panel, will be based off page title then menu title then opt_name if not provided
    'save_defaults'        => true,
    // On load save the defaults to DB before user clicks save or not
    'default_show'         => false,
    // If true, shows the default value next to each field that is not the default value.
    'default_mark'         => '',
    // What to print by the field's title if the value shown is default. Suggested: *
    'show_import_export'   => true,
    // Shows the Import/Export panel when not used as a field.

    // CAREFUL -> These options are for advanced use only
    'transient_time'       => 60 * MINUTE_IN_SECONDS,
    'output'               => true,
    // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
    'output_tag'           => true,
    // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head
    // 'footer_credit'     => '',                   // Disable the footer credit of Redux. Please leave if you can help it.

    // FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
    'database'             => '',
    // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
    'use_cdn'              => true,
    // If you prefer not to use the CDN for Select2, Ace Editor, and others, you may download the Redux Vendor Support plugin yourself and run locally or embed it in your code.

    // HINTS
    'hints'                => array(
        'icon'          => 'el el-question-sign',
        'icon_position' => 'right',
        'icon_color'    => 'lightgray',
        'icon_size'     => 'normal',
        'tip_style'     => array(
            'color'   => 'red',
            'shadow'  => true,
            'rounded' => false,
            'style'   => '',
        ),
        'tip_position'  => array(
            'my' => 'top left',
            'at' => 'bottom right',
        ),
        'tip_effect'    => array(
            'show' => array(
                'effect'   => 'slide',
                'duration' => '500',
                'event'    => 'mouseover',
            ),
            'hide' => array(
                'effect'   => 'slide',
                'duration' => '500',
                'event'    => 'click mouseleave',
            ),
        ),
    ),
    'templates_path'       => get_template_directory() . '/inc/templates/redux/'
);

Redux::SetArgs($opt_name, $args);

/*--------------------------------------------------------------
# General
--------------------------------------------------------------*/

Redux::setSection($opt_name, array(
    'title'  => esc_html__('General', 'bixol'),
    'icon'   => 'el-icon-home',
    'fields' => array(
        array(
            'id'       => 'favicon',
            'type'     => 'media',
            'title'    => esc_html__('Favicon', 'bixol'),
            'default' => ''
        ),
        array(
            'id'       => 'dev_mode',
            'type'     => 'switch',
            'title'    => esc_html__('Dev Mode (not recommended)', 'bixol'),
            'description' => 'no minimize , generate css over time...',
            'default'  => false
        ),
        array(
            'id'       => 'show_page_loading',
            'type'     => 'switch',
            'title'    => esc_html__('Enable Page Loading', 'bixol'),
            'subtitle' => esc_html__('Enable page loading effect when you load site.', 'bixol'),
            'default'  => false
        ),
        array(
            'id'       => 'loading_type',
            'type'     => 'select',
            'title'    => esc_html__('Loading Style', 'bixol'),
            'options'  => array(
                'style-image'  => esc_html__('Image', 'bixol'),
                'style1'  => esc_html__('Style 1', 'bixol'),
                'style2'  => esc_html__('Style 2', 'bixol'),
                'style3'  => esc_html__('Style 3', 'bixol'),
                'style4'  => esc_html__('Style 4', 'bixol'),
                'style5'  => esc_html__('Style 5', 'bixol'),
                'style6'  => esc_html__('Style 6', 'bixol'),
                'style7'  => esc_html__('Style 7', 'bixol'),
                'style8'  => esc_html__('Style 8', 'bixol'),
                'style9'  => esc_html__('Style 9', 'bixol'),
                'style10'  => esc_html__('Style 10', 'bixol'),
                'style11'  => esc_html__('Style 11', 'bixol'),
                'style12'  => esc_html__('Style 12', 'bixol'),
                'style13'  => esc_html__('Style 13', 'bixol'),
            ),
            'default'  => 'style-image',
            'required' => array( 0 => 'show_page_loading', 1 => 'equals', 2 => '1' ),
            'force_output' => true
        ),
        array(
            'id'       => 'logo_loader',
            'type'     => 'media',
            'title'    => esc_html__('Logo Dark', 'bixol'),
            'default' => array(
                'url'=>get_template_directory_uri().'/assets/images/logo-loader.gif'
            ),
            'required' => array( 0 => 'loading_type', 1 => 'equals', 2 => 'style-image' ),
            'force_output' => true
        ),
    )
));

/*--------------------------------------------------------------
# Header
--------------------------------------------------------------*/

Redux::setSection($opt_name, array(
    'title'  => esc_html__('Header', 'bixol'),
    'icon'   => 'el el-indent-left',
    'fields' => array(
        array(
            'id'       => 'header_type',
            'type'     => 'button_set',
            'title'    => esc_html__('Header Type', 'bixol'),
            'options'  => array(
                'layout'  => esc_html__('Default Layout', 'bixol'),
                'custom'  => esc_html__('Custom Layout Builder', 'bixol')
            ),
            'default'  => 'layout',
        ),
        array(
            'id'          => 'e_header_layout',
            'type'        => 'select',
            'title'       => esc_html__('Main Header Layout', 'bixol'),
            'desc'        => sprintf(esc_html__('To use this Option please %sClick Here%s to add your header layout first.','bixol'),'<a href="' . esc_url( admin_url( 'edit.php?post_type=header' ) ) . '">','</a>'),
            'options'     => bixol_list_post('header'),
            'default'     => '',
            'required' => array( 0 => 'header_type', 1 => 'equals', 2 => 'custom' ),
        ),
        array(
            'id'          => 'e_header_layout_sticky',
            'type'        => 'select',
            'title'       => esc_html__('Sticky Header Layout', 'bixol'),
            'desc'        => sprintf(esc_html__('To use this Option please %sClick Here%s to add your header layout first.','bixol'),'<a href="' . esc_url( admin_url( 'edit.php?post_type=header' ) ) . '">','</a>'),
            'options'     => bixol_list_post('header'),
            'default'     => '',
            'required' => array( 0 => 'header_type', 1 => 'equals', 2 => 'custom' ),
        ),
        array(
            'id'       => 'header_layout',
            'type'     => 'image_select',
            'title'    => esc_html__('Layout', 'bixol'),
            'subtitle' => esc_html__('Select a layout for header.', 'bixol'),
            'options'  => array(
                '1' => get_template_directory_uri() . '/assets/images/header-layout/h1.jpg',
                '2' => get_template_directory_uri() . '/assets/images/header-layout/h2.jpg',
                '3' => get_template_directory_uri() . '/assets/images/header-layout/h3.jpg',
                '4' => get_template_directory_uri() . '/assets/images/header-layout/h4.jpg',
                '5' => get_template_directory_uri() . '/assets/images/header-layout/h5.jpg',
                '6' => get_template_directory_uri() . '/assets/images/header-layout/h6.jpg',
                '7' => get_template_directory_uri() . '/assets/images/header-layout/h7.jpg',
            ),
            'default'  => '4',
            'required' => array( 0 => 'header_type', 1 => 'equals', 2 => 'layout' ),
        ),
        array(
            'id'       => 'header_bg',
            'type'     => 'background',
            'title'    => esc_html__('Background Color', 'bixol'),
            'output'   => array('body #ct-header-wrap #ct-header, body #ct-header-wrap.ct-header-layout1 #ct-header, #ct-header-wrap.ct-header-layout1 #ct-header.h-fixed'),
            'background-image' => false,
            'background-color' => true,
            'background-position' => false,
            'background-repeat' => false,
            'background-size' => false,
            'background-attachment' => false,
            'transparent' => false,
            'required' => array( 0 => 'header_type', 1 => 'equals', 2 => 'layout' ),
        ),
        array(
            'id'       => 'sticky_on',
            'type'     => 'switch',
            'title'    => esc_html__('Sticky Header', 'bixol'),
            'subtitle' => esc_html__('Header will be sticked when applicable.', 'bixol'),
            'default'  => false,
            'required' => array( 0 => 'header_type', 1 => 'equals', 2 => 'layout' ),
        ),
        array(
            'id'       => 'h_search_form',
            'type'     => 'switch',
            'title'    => esc_html__('Search Form', 'bixol'),
            'default'  => false,
            'required' => array( 0 => 'header_type', 1 => 'equals', 2 => 'layout' ),
        ),
        array(
            'id'       => 'search_icon',
            'type'     => 'switch',
            'title'    => esc_html__('Search Icon', 'bixol'),
            'default'  => false,
            'required' => array( 0 => 'header_type', 1 => 'equals', 2 => 'layout' ),
        ),
        array(
            'id'       => 'search_mobile',
            'type'     => 'switch',
            'title'    => esc_html__('Search Mobile', 'bixol'),
            'default'  => false,
            'required' => array( 0 => 'header_type', 1 => 'equals', 2 => 'layout' ),
        ),
        array(
            'id'       => 'cart_icon',
            'type'     => 'switch',
            'title'    => esc_html__('Cart Icon', 'bixol'),
            'default'  => false,
            'subtitle' => esc_html__('Apply header layout 7.', 'bixol'),
            'required' => array( 0 => 'header_type', 1 => 'equals', 2 => 'layout' ),
        ),
        array(
            'id'       => 'cart_icon_mobile',
            'type'     => 'switch',
            'title'    => esc_html__('Cart Icon Mobile', 'bixol'),
            'default'  => false,
            'subtitle' => esc_html__('Apply header layout 7.', 'bixol'),
            'required' => array( 0 => 'header_type', 1 => 'equals', 2 => 'layout' ),
        ),
        array(
            'title' => esc_html__('Button Navigation', 'bixol'),
            'type'  => 'section',
            'id' => 'button_navigation1',
            'indent' => true,
            'required' => array( 0 => 'header_type', 1 => 'equals', 2 => 'layout' ),
        ),
        array(
            'id'       => 'h_btn_on',
            'type'     => 'button_set',
            'title'    => esc_html__('Show/Hide Button', 'bixol'),
            'options'  => array(
                'show'  => esc_html__('Show', 'bixol'),
                'hide'  => esc_html__('Hide', 'bixol')
            ),
            'default'  => 'hide',
            'required' => array( 0 => 'header_type', 1 => 'equals', 2 => 'layout' ),
        ),
        array(
            'id' => 'h_btn_text',
            'type' => 'text',
            'title' => esc_html__('Button Text', 'bixol'),
            'default' => '',
            'required' => array( 0 => 'h_btn_on', 1 => 'equals', 2 => 'show' ),
            'force_output' => true,
            'required' => array( 0 => 'header_type', 1 => 'equals', 2 => 'layout' ),
        ),
        array(
            'id'       => 'h_btn_link_type',
            'type'     => 'button_set',
            'title'    => esc_html__('Button Link Type', 'bixol'),
            'options'  => array(
                'page'  => esc_html__('Page', 'bixol'),
                'custom'  => esc_html__('Custom', 'bixol')
            ),
            'default'  => 'page',
            'required' => array( 0 => 'h_btn_on', 1 => 'equals', 2 => 'show' ),
            'force_output' => true
        ),
        array(
            'id'    => 'h_btn_link',
            'type'  => 'select',
            'title' => esc_html__( 'Page Link', 'bixol' ), 
            'data'  => 'page',
            'args'  => array(
                'post_type'      => 'page',
                'posts_per_page' => -1,
                'orderby'        => 'title',
                'order'          => 'ASC',
            ),
            'required' => array( 0 => 'h_btn_link_type', 1 => 'equals', 2 => 'page' ),
            'force_output' => true
        ),
        array(
            'id' => 'h_btn_link_custom',
            'type' => 'text',
            'title' => esc_html__('Custom Link', 'bixol'),
            'default' => '',
            'required' => array( 0 => 'h_btn_link_type', 1 => 'equals', 2 => 'custom' ),
            'force_output' => true
        ),
        array(
            'id'       => 'h_btn_target',
            'type'     => 'button_set',
            'title'    => esc_html__('Button Target', 'bixol'),
            'options'  => array(
                '_self'  => esc_html__('Self', 'bixol'),
                '_blank'  => esc_html__('Blank', 'bixol')
            ),
            'default'  => '_self',
            'required' => array( 0 => 'h_btn_on', 1 => 'equals', 2 => 'show' ),
            'force_output' => true
        ),
    )
));

Redux::setSection($opt_name, array(
    'title'      => esc_html__('Top Bar', 'bixol'),
    'icon'       => 'el el-credit-card',
    'subsection' => true,
    'fields'     => array(
        array(
            'id'           => 'top_bar',
            'type'         => 'button_set',
            'title'        => esc_html__( 'Top Bar', 'bixol' ),
            'options'      => array(
                'show'  => esc_html__( 'Show', 'bixol' ),
                'hide'  => esc_html__( 'Hide', 'bixol' ),
            ),
            'default'      => 'hide',
        ),
        array(
            'id'       => 'topbar_bg',
            'type'     => 'background',
            'title'    => esc_html__('Background Color', 'bixol'),
            'output'   => array('body #ct-header-wrap #ct-topbar'),
            'background-image' => false,
            'background-color' => true,
            'background-position' => false,
            'background-repeat' => false,
            'background-size' => false,
            'background-attachment' => false,
            'transparent' => false,
        ),
        array(
            'id'          => 'topbar_icon_color',
            'type'        => 'color',
            'title'       => esc_html__('Icon Color', 'bixol'),
            'transparent' => false,
            'default'     => '',
            'output'   => array('body #ct-header-wrap #ct-topbar .ct-topbar-meta i, body #ct-header-wrap #ct-header-middle .ct-h-middle-icon'),
        ),
        array(
            'id' => 'h_introductory',
            'type' => 'text',
            'title' => esc_html__('Introductory', 'bixol'),
            'default' => '',
        ),
        array(
            'id' => 'h_phone_label',
            'type' => 'text',
            'title' => esc_html__('Phone Number Label', 'bixol'),
            'default' => '',
        ),
        array(
            'id' => 'h_phone',
            'type' => 'text',
            'title' => esc_html__('Phone Number', 'bixol'),
            'default' => '',
        ),
        array(
            'id' => 'h_phone_link',
            'type' => 'text',
            'title' => esc_html__('Phone Link', 'bixol'),
            'default' => '',
        ),
        array(
            'id' => 'h_email_label',
            'type' => 'text',
            'title' => esc_html__('Email Label', 'bixol'),
            'default' => '',
        ),
        array(
            'id' => 'h_email',
            'type' => 'text',
            'title' => esc_html__('Email', 'bixol'),
            'default' => '',
        ),
        array(
            'id' => 'h_email_link',
            'type' => 'text',
            'title' => esc_html__('Email Link', 'bixol'),
            'default' => '',
        ),
        array(
            'id' => 'h_address_label',
            'type' => 'text',
            'title' => esc_html__('Address Label', 'bixol'),
            'default' => '',
        ),
        array(
            'id' => 'h_address',
            'type' => 'text',
            'title' => esc_html__('Address', 'bixol'),
            'default' => '',
        ),
        array(
            'id' => 'h_address_link',
            'type' => 'text',
            'title' => esc_html__('Address Link', 'bixol'),
            'default' => '',
        ),
        array(
            'id' => 'h_time_label',
            'type' => 'text',
            'title' => esc_html__('Time Label 1', 'bixol'),
            'default' => '',
            'description' => 'Apply header layout 1.',
        ),
        array(
            'id' => 'h_time_label2',
            'type' => 'text',
            'title' => esc_html__('Time Label 2', 'bixol'),
            'default' => '',
            'description' => 'Apply header layout 3.',
        ),
        array(
            'id' => 'h_time',
            'type' => 'text',
            'title' => esc_html__('Time 1', 'bixol'),
            'default' => '',
            'description' => 'Apply header layout 1.',
        ),
        array(
            'id' => 'h_time2',
            'type' => 'text',
            'title' => esc_html__('Time 2', 'bixol'),
            'default' => '',
            'description' => 'Apply header layout 3.',
        ),
        array(
            'title' => esc_html__('Social', 'bixol'),
            'type'  => 'section',
            'id' => 'header_social',
            'indent' => true,
        ),

        array(
            'id'      => 'h_social_facebook_url',
            'type'    => 'text',
            'title'   => esc_html__('Facebook URL', 'bixol'),
            'default' => '',
        ),
        array(
            'id'      => 'h_social_twitter_url',
            'type'    => 'text',
            'title'   => esc_html__('Twitter URL', 'bixol'),
            'default' => '#',
        ),
        array(
            'id'      => 'h_social_inkedin_url',
            'type'    => 'text',
            'title'   => esc_html__('Linkedin URL', 'bixol'),
            'default' => '',
        ),
        array(
            'id'      => 'h_social_instagram_url',
            'type'    => 'text',
            'title'   => esc_html__('Instagram URL', 'bixol'),
            'default' => '#',
        ),
        array(
            'id'      => 'h_social_google_url',
            'type'    => 'text',
            'title'   => esc_html__('Google URL', 'bixol'),
            'default' => '',
        ),
        array(
            'id'      => 'h_social_skype_url',
            'type'    => 'text',
            'title'   => esc_html__('Skype URL', 'bixol'),
            'default' => '',
        ),
        array(
            'id'      => 'h_social_pinterest_url',
            'type'    => 'text',
            'title'   => esc_html__('Pinterest URL', 'bixol'),
            'default' => '',
        ),
        array(
            'id'      => 'h_social_vimeo_url',
            'type'    => 'text',
            'title'   => esc_html__('Vimeo URL', 'bixol'),
            'default' => '',
        ),
        array(
            'id'      => 'h_social_youtube_url',
            'type'    => 'text',
            'title'   => esc_html__('Youtube URL', 'bixol'),
            'default' => '',
        ),
        array(
            'id'      => 'h_social_yelp_url',
            'type'    => 'text',
            'title'   => esc_html__('Yelp URL', 'bixol'),
            'default' => '',
        ),
        array(
            'id'      => 'h_social_tumblr_url',
            'type'    => 'text',
            'title'   => esc_html__('Tumblr URL', 'bixol'),
            'default' => '',
        ),
        array(
            'id'      => 'h_social_tripadvisor_url',
            'type'    => 'text',
            'title'   => esc_html__('Tripadvisor URL', 'bixol'),
            'default' => '#',
        ),
    )
));

Redux::setSection($opt_name, array(
    'title'      => esc_html__('Logo', 'bixol'),
    'icon'       => 'el el-picture',
    'subsection' => true,
    'fields'     => array(
        array(
            'id'       => 'logo',
            'type'     => 'media',
            'title'    => esc_html__('Logo Dark', 'bixol'),
             'default' => array(
                'url'=>get_template_directory_uri().'/assets/images/logo-dark.png'
            )
        ),
        array(
            'id'       => 'logo_mobile',
            'type'     => 'media',
            'title'    => esc_html__('Logo Tablet & Mobile', 'bixol'),
             'default' => array(
                'url'=>get_template_directory_uri().'/assets/images/logo-mobile.png'
            )
        ),
        array(
            'id'       => 'logo_maxh',
            'type'     => 'dimensions',
            'title'    => esc_html__('Logo Max Height', 'bixol'),
            'subtitle' => esc_html__('Enter number.', 'bixol'),
            'width'    => false,
            'unit'     => 'px'
        ),
        array(
            'id'       => 'logo_maxh_sm',
            'type'     => 'dimensions',
            'title'    => esc_html__('Logo Max Height for Tablet & Mobile', 'bixol'),
            'subtitle' => esc_html__('Enter number.', 'bixol'),
            'width'    => false,
            'unit'     => 'px'
        ),
    )
));

Redux::setSection($opt_name, array(
    'title'      => esc_html__('Navigation', 'bixol'),
    'icon'       => 'el el-lines',
    'subsection' => true,
    'fields'     => array(
        array(
            'id'          => 'font_menu',
            'type'        => 'typography',
            'title'       => esc_html__('Custom Google Font', 'bixol'),
            'google'      => true,
            'font-backup' => true,
            'all_styles'  => true,
            'font-style'  => false,
            'font-weight'  => true,
            'text-align'  => false,
            'font-size'  => false,
            'line-height'  => false,
            'color'  => false,
            'output'      => array('body #ct-header-wrap #ct-header.ct-header-main .ct-main-menu > li > a, body #ct-header-wrap #ct-header.ct-header-main .ct-main-menu .sub-menu li a'),
            'units'       => 'px',
        ),
        array(
            'title' => esc_html__('Main Menu', 'bixol'),
            'type'  => 'section',
            'id' => 'main_menu',
            'indent' => true
        ),
        array(
            'id'       => 'icon_has_children',
            'type'     => 'button_set',
            'title'    => esc_html__('Icon Has Children', 'bixol'),
            'options'  => array(
                'plus'  => esc_html__('Plus', 'bixol'),
                'arrow'  => esc_html__('Arrow', 'bixol')
            ),
            'default'  => 'plus',
        ),
        array(
            'id'      => 'main_menu_color',
            'type'    => 'link_color',
            'title'   => esc_html__('Item Color', 'bixol'),
            'default' => array(
                'regular' => '',
                'hover'   => '',
                'active'   => '',
            ),
        ),
        array(
            'id'          => 'menu_icon_color',
            'type'        => 'color',
            'title'       => esc_html__('Icon Color', 'bixol'),
            'transparent' => false,
        ),
        array(
            'id'       => 'mobile_menu_item_click',
            'type'     => 'button_set',
            'title'    => esc_html__('Mobile Menu Clicked', 'bixol'),
            'options'  => array(
                'default'  => esc_html__('Show', 'bixol'),
                'menu-hide'  => esc_html__('Hidden', 'bixol')
            ),
            'default'  => 'default',
        ),
        array(
            'title' => esc_html__('Sticky Menu', 'bixol'),
            'type'  => 'section',
            'id' => 'sticky_menu',
            'indent' => true
        ),
        array(
            'id'      => 'sticky_menu_color',
            'type'    => 'link_color',
            'title'   => esc_html__('Item Color', 'bixol'),
            'default' => array(
                'regular' => '',
                'hover'   => '',
                'active'   => '',
            ),
        ),
        array(
            'title' => esc_html__('Sub Menu', 'bixol'),
            'type'  => 'section',
            'id' => 'sub_menu',
            'indent' => true
        ),
        array(
            'id'      => 'sub_menu_color',
            'type'    => 'link_color',
            'title'   => esc_html__('Item Color', 'bixol'),
            'default' => array(
                'regular' => '',
                'hover'   => '',
                'active'   => '',
            ),
        ),
    )
));

/*--------------------------------------------------------------
# Page Title area
--------------------------------------------------------------*/

Redux::setSection($opt_name, array(
    'title'  => esc_html__('Page Title', 'bixol'),
    'icon'   => 'el-icon-map-marker',
    'fields' => array(

        array(
            'id'           => 'pagetitle',
            'type'         => 'button_set',
            'title'        => esc_html__( 'Page Title', 'bixol' ),
            'options'      => array(
                'show'  => esc_html__( 'Show', 'bixol' ),
                'hide'  => esc_html__( 'Hide', 'bixol' ),
            ),
            'default'      => 'show',
        ),

        array(
            'id'       => 'ptitle_bg',
            'type'     => 'background',
            'title'    => esc_html__('Background', 'bixol'),
            'subtitle' => esc_html__('Page title background.', 'bixol'),
            'output'   => array('body #pagetitle.page-title'),
            'required' => array( 0 => 'pagetitle', 1 => 'equals', 2 => 'show' ),
            'force_output' => true,
            'background-image' => true,
            'background-color' => false,
            'background-position' => false,
            'background-repeat' => false,
            'background-size' => false,
            'background-attachment' => false,
            'transparent' => false,
        ),
        array(
            'id'             => 'page_title_padding',
            'type'           => 'spacing',
            'output'         => array('body #pagetitle.page-title'),
            'right'   => false,
            'left'    => false,
            'mode'           => 'padding',
            'units'          => array('px'),
            'units_extended' => 'false',
            'title'          => esc_html__('Page Title Padding', 'bixol'),
            'desc'           => esc_html__('Default: Top-126px, Bottom-116px', 'bixol'),
            'default'            => array(
                'padding-top'   => '',
                'padding-bottom'   => '',
                'units'          => 'px',
            ),
            'required' => array( 0 => 'pagetitle', 1 => 'equals', 2 => 'show' ),
            'force_output' => true
        ),
        array(
            'id'       => 'ptitle_breadcrumb_on',
            'type'     => 'button_set',
            'title'    => esc_html__('Breadcrumb', 'bixol'),
            'options'  => array(
                'show'  => esc_html__('Show', 'bixol'),
                'hidden'  => esc_html__('Hidden', 'bixol'),
            ),
            'default'  => 'show',
            'required' => array( 0 => 'pagetitle', 1 => 'equals', 2 => 'show' ),
            'force_output' => true
        ),
    )
));

/*--------------------------------------------------------------
# WordPress default content
--------------------------------------------------------------*/

Redux::setSection($opt_name, array(
    'title' => esc_html__('Content', 'bixol'),
    'icon'  => 'el-icon-pencil',
    'fields'     => array(
        array(
            'id'       => 'content_bg',
            'type'     => 'background',
            'title'    => esc_html__('Background', 'bixol'),
            'subtitle' => esc_html__('Content background.', 'bixol'),
            'output'   => array( 'background-color' => '.site-content' ),
            'force_output' => true,
            'background-image' => true,
            'background-color' => true,
            'background-position' => true,
            'background-repeat' => true,
            'background-size' => true,
            'background-attachment' => true,
            'transparent' => false,
        ),
        array(
            'id'             => 'content_padding',
            'type'           => 'spacing',
            'output'         => array('#content'),
            'right'   => false,
            'left'    => false,
            'mode'           => 'padding',
            'units'          => array('px'),
            'units_extended' => 'false',
            'title'          => esc_html__('Content Padding', 'bixol'),
            'desc'           => esc_html__('Default: Top-80px, Bottom-80px', 'bixol'),
            'default'            => array(
                'padding-top'   => '',
                'padding-bottom'   => '',
                'units'          => 'px',
            )
        ),
        array(
            'id'      => 'search_field_placeholder',
            'type'    => 'text',
            'title'   => esc_html__('Search Form - Text Placeholder', 'bixol'),
            'default' => '',
            'desc'           => esc_html__('Default: Search Keywords...', 'bixol'),
        ),
    )
));


Redux::setSection($opt_name, array(
    'title'      => esc_html__('Archive', 'bixol'),
    'icon'       => 'el-icon-list',
    'subsection' => true,
    'fields'     => array(
        array(
            'id'       => 'archive_sidebar_pos',
            'type'     => 'button_set',
            'title'    => esc_html__('Sidebar Position', 'bixol'),
            'subtitle' => esc_html__('Select a sidebar position for blog home, archive, search...', 'bixol'),
            'options'  => array(
                'left'  => esc_html__('Left', 'bixol'),
                'right' => esc_html__('Right', 'bixol'),
                'none'  => esc_html__('Disabled', 'bixol')
            ),
            'default'  => 'right'
        ),
        array(
            'id'       => 'archive_author_display',
            'title'    => esc_html__('Author', 'bixol'),
            'subtitle' => esc_html__('Show author posted on each post.', 'bixol'),
            'type'     => 'switch',
            'default'  => true,
        ),
        array(
            'id'       => 'archive_date_on',
            'title'    => esc_html__('Date', 'bixol'),
            'subtitle' => esc_html__('Show date posted on each post.', 'bixol'),
            'type'     => 'switch',
            'default'  => true,
        ),
        array(
            'id'       => 'archive_categories_display',
            'title'    => esc_html__('Categories', 'bixol'),
            'subtitle' => esc_html__('Show category names on each post.', 'bixol'),
            'type'     => 'switch',
            'default'  => true,
        ),
        array(
            'id'       => 'archive_social_share_on',
            'title'    => esc_html__('Social Share', 'bixol'),
            'subtitle' => esc_html__('Show social share on each post.', 'bixol'),
            'type'     => 'switch',
            'default'  => false,
        ),
        array(
            'id'      => 'archive_readmore_text',
            'type'    => 'text',
            'title'   => esc_html__('Read More Text', 'bixol'),
            'default' => '',
        ),
    )
));

Redux::setSection($opt_name, array(
    'title'      => esc_html__('Single Post', 'bixol'),
    'icon'       => 'el-icon-file-edit',
    'subsection' => true,
    'fields'     => array(
        array(
            'id'       => 'post_sidebar_pos',
            'type'     => 'button_set',
            'title'    => esc_html__('Sidebar Position', 'bixol'),
            'subtitle' => esc_html__('Select a sidebar position', 'bixol'),
            'options'  => array(
                'left'  => esc_html__('Left', 'bixol'),
                'right' => esc_html__('Right', 'bixol'),
                'none'  => esc_html__('Disabled', 'bixol')
            ),
            'default'  => 'right'
        ),
        array(
            'id'       => 'post_date_on',
            'title'    => esc_html__('Date', 'bixol'),
            'subtitle' => esc_html__('Show date on single post.', 'bixol'),
            'type'     => 'switch',
            'default'  => true
        ),
        array(
            'id'       => 'post_author_on',
            'title'    => esc_html__('Author', 'bixol'),
            'subtitle' => esc_html__('Show author name on single post.', 'bixol'),
            'type'     => 'switch',
            'default'  => true
        ),
        array(
            'id'       => 'post_comment_on',
            'title'    => esc_html__('Comment', 'bixol'),
            'subtitle' => esc_html__('Show comment name on single post.', 'bixol'),
            'type'     => 'switch',
            'default'  => true
        ),
        array(
            'id'       => 'post_categories_on',
            'title'    => esc_html__('Categories', 'bixol'),
            'subtitle' => esc_html__('Show category names on single post.', 'bixol'),
            'type'     => 'switch',
            'default'  => true
        ),
        array(
            'id'       => 'post_tags_on',
            'title'    => esc_html__('Tags', 'bixol'),
            'subtitle' => esc_html__('Show tag names on single post.', 'bixol'),
            'type'     => 'switch',
            'default'  => true
        ),
        array(
            'id'       => 'post_navigation_on',
            'title'    => esc_html__('Navigation', 'bixol'),
            'subtitle' => esc_html__('Show navigation on single post.', 'bixol'),
            'type'     => 'switch',
            'default'  => false,
        ),
        array(
            'id'       => 'post_social_share_on',
            'title'    => esc_html__('Social Share', 'bixol'),
            'subtitle' => esc_html__('Show social share on single post.', 'bixol'),
            'type'     => 'switch',
            'default'  => false,
        ),
    )
));

/*--------------------------------------------------------------
# Shop
--------------------------------------------------------------*/
if(class_exists('Woocommerce')) {
    Redux::setSection($opt_name, array(
        'title'  => esc_html__('Shop', 'bixol'),
        'icon'   => 'el el-shopping-cart',
        'fields' => array(
            array(
                'id'       => 'sidebar_shop',
                'type'     => 'button_set',
                'title'    => esc_html__('Sidebar Position', 'bixol'),
                'subtitle' => esc_html__('Select a sidebar position for archive shop.', 'bixol'),
                'options'  => array(
                    'left'  => esc_html__('Left', 'bixol'),
                    'right' => esc_html__('Right', 'bixol'),
                    'none'  => esc_html__('Disabled', 'bixol')
                ),
                'default'  => 'right'
            ),
            array(
                'title' => esc_html__('Products displayed per page', 'bixol'),
                'id' => 'product_per_page',
                'type' => 'slider',
                'subtitle' => esc_html__('Number product to show', 'bixol'),
                'default' => 8,
                'min'  => 4,
                'step' => 1,
                'max' => 50,
                'display_value' => 'text'
            ),
        )
    ));
}

/*--------------------------------------------------------------
# Footer
--------------------------------------------------------------*/

Redux::setSection($opt_name, array(
    'title'  => esc_html__('Footer', 'bixol'),
    'icon'   => 'el el-website',
    'fields' => array(
        array(
            'id'          => 'footer_layout_custom',
            'type'        => 'select',
            'title'       => esc_html__('Layout', 'bixol'),
            'desc'        => sprintf(esc_html__('To use this Option please %sClick Here%s to add your custom footer layout first.','bixol'),'<a href="' . esc_url( admin_url( 'edit.php?post_type=footer' ) ) . '">','</a>'),
            'options'     =>bixol_list_post('footer'),
            'default'     => '',
        ),
        array(
            'id'       => 'back_totop_on',
            'type'     => 'switch',
            'title'    => esc_html__('Back to Top Button', 'bixol'),
            'subtitle' => esc_html__('Show back to top button when scrolled down.', 'bixol'),
            'default'  => false,
        ),
        array(
            'id'       => 'fixed_footer',
            'type'     => 'switch',
            'title'    => esc_html__('Fixed Footer', 'bixol'),
            'default'  => false,
        ),
    )
));

/* 404 Page /--------------------------------------------------------- */
Redux::setSection($opt_name, array(
    'title'  => esc_html__('404 Page', 'bixol'),
    'icon'   => 'el-cog-alt el',
    'fields' => array(
        array(
            'id'       => 'page_404',
            'type'     => 'button_set',
            'title'    => esc_html__('Select 404 Page', 'bixol'),
            'options'  => array(
                'default'  => esc_html__('Default', 'bixol'),
                'custom'  => esc_html__('Custom', 'bixol'),
            ),
            'default'  => 'default'
        ),
        array(
            'id'          => 'page_custom_404',
            'type'        => 'select',
            'title'       => esc_html__('Page', 'bixol'),
            'options'     => bixol_list_post('page'),
            'default'     => '',
            'required' => array( 0 => 'page_404', 1 => 'equals', 2 => 'custom' ),
            'force_output' => true
        ),
    ),
));

/*--------------------------------------------------------------
# Colors
--------------------------------------------------------------*/

Redux::setSection($opt_name, array(
    'title'  => esc_html__('Colors', 'bixol'),
    'icon'   => 'el-icon-file-edit',
    'fields' => array(
        array(
            'id'          => 'primary_color',
            'type'        => 'color',
            'title'       => esc_html__('Primary Color', 'bixol'),
            'transparent' => false,
            'default'     => '#22d3ee'
        ),
        array(
            'id'          => 'secondary_color',
            'type'        => 'color',
            'title'       => esc_html__('Secondary Color', 'bixol'),
            'transparent' => false,
            'default'     => '#0431b8'
        ),
        array(
            'id'          => 'third_color',
            'type'        => 'color',
            'title'       => esc_html__('Third Color', 'bixol'),
            'transparent' => false,
            'default'     => '#4a74f0'
        ),
        array(
            'id'          => 'four_color',
            'type'        => 'color',
            'title'       => esc_html__('Fourth Color', 'bixol'),
            'transparent' => false,
            'default'     => '#2593d5'
        ),
        array(
            'id'          => 'fifth_color',
            'type'        => 'color',
            'title'       => esc_html__('Fifth Color', 'bixol'),
            'transparent' => false,
            'default'     => '#8cd102'
        ),
        array(
            'id'          => 'dark_color',
            'type'        => 'color',
            'title'       => esc_html__('Dark Color', 'bixol'),
            'transparent' => false,
            'default'     => '#082680'
        ),
        array(
            'id'      => 'link_color',
            'type'    => 'link_color',
            'title'   => esc_html__('Link Colors', 'bixol'),
            'default' => array(
                'regular' => '#22d3ee',
                'hover'   => '#0431b8',
                'active'  => '#0431b8'
            ),
            'output'  => array('a')
        ),
    )
));

/*--------------------------------------------------------------
# Typography
--------------------------------------------------------------*/
$custom_font_selectors_1 = Redux::get_option($opt_name, 'custom_font_selectors_1');
$custom_font_selectors_1 = !empty($custom_font_selectors_1) ? explode(',', $custom_font_selectors_1) : array();
Redux::setSection($opt_name, array(
    'title'  => esc_html__('Typography', 'bixol'),
    'icon'   => 'el-icon-text-width',
    'fields' => array(
        array(
            'id'       => 'body_default_font',
            'type'     => 'select',
            'title'    => esc_html__('Body Default Font', 'bixol'),
            'options'  => array(
                'Rubik'  => esc_html__('Default', 'bixol'),
                'Google-Font'  => esc_html__('Google Font', 'bixol'),
            ),
            'default'  => 'Rubik',
        ),
        array(
            'id'          => 'font_main',
            'type'        => 'typography',
            'title'       => esc_html__('Body Google Font', 'bixol'),
            'subtitle'    => esc_html__('This will be the default font of your website.', 'bixol'),
            'google'      => true,
            'font-backup' => true,
            'all_styles'  => true,
            'line-height'  => true,
            'font-size'  => true,
            'text-align'  => false,
            'output'      => array('body'),
            'units'       => 'px',
            'required' => array( 0 => 'body_default_font', 1 => 'equals', 2 => 'Google-Font' ),
            'force_output' => true
        ),
        array(
            'id'       => 'heading_default_font',
            'type'     => 'select',
            'title'    => esc_html__('Heading Default Font', 'bixol'),
            'options'  => array(
                'Poppins'  => esc_html__('Default', 'bixol'),
                'Google-Font'  => esc_html__('Google Font', 'bixol'),
            ),
            'default'  => 'Poppins',
        ),
        array(
            'id'          => 'font_h1',
            'type'        => 'typography',
            'title'       => esc_html__('H1', 'bixol'),
            'subtitle'    => esc_html__('This will be the default font for all H1 tags of your website.', 'bixol'),
            'google'      => true,
            'font-backup' => true,
            'all_styles'  => true,
            'text-align'  => false,
            'output'      => array('h1', '.h1', '.text-heading'),
            'units'       => 'px',
            'required' => array( 0 => 'heading_default_font', 1 => 'equals', 2 => 'Google-Font' ),
            'force_output' => true
        ),
        array(
            'id'          => 'font_h2',
            'type'        => 'typography',
            'title'       => esc_html__('H2', 'bixol'),
            'subtitle'    => esc_html__('This will be the default font for all H2 tags of your website.', 'bixol'),
            'google'      => true,
            'font-backup' => true,
            'all_styles'  => true,
            'text-align'  => false,
            'output'      => array('h2', '.h2'),
            'units'       => 'px',
            'required' => array( 0 => 'heading_default_font', 1 => 'equals', 2 => 'Google-Font' ),
            'force_output' => true
        ),
        array(
            'id'          => 'font_h3',
            'type'        => 'typography',
            'title'       => esc_html__('H3', 'bixol'),
            'subtitle'    => esc_html__('This will be the default font for all H3 tags of your website.', 'bixol'),
            'google'      => true,
            'font-backup' => true,
            'all_styles'  => true,
            'text-align'  => false,
            'output'      => array('h3', '.h3'),
            'units'       => 'px',
            'required' => array( 0 => 'heading_default_font', 1 => 'equals', 2 => 'Google-Font' ),
            'force_output' => true
        ),
        array(
            'id'          => 'font_h4',
            'type'        => 'typography',
            'title'       => esc_html__('H4', 'bixol'),
            'subtitle'    => esc_html__('This will be the default font for all H4 tags of your website.', 'bixol'),
            'google'      => true,
            'font-backup' => true,
            'all_styles'  => true,
            'text-align'  => false,
            'output'      => array('h4', '.h4'),
            'units'       => 'px',
            'required' => array( 0 => 'heading_default_font', 1 => 'equals', 2 => 'Google-Font' ),
            'force_output' => true
        ),
        array(
            'id'          => 'font_h5',
            'type'        => 'typography',
            'title'       => esc_html__('H5', 'bixol'),
            'subtitle'    => esc_html__('This will be the default font for all H5 tags of your website.', 'bixol'),
            'google'      => true,
            'font-backup' => true,
            'all_styles'  => true,
            'text-align'  => false,
            'output'      => array('h5', '.h5'),
            'units'       => 'px',
            'required' => array( 0 => 'heading_default_font', 1 => 'equals', 2 => 'Google-Font' ),
            'force_output' => true
        ),
        array(
            'id'          => 'font_h6',
            'type'        => 'typography',
            'title'       => esc_html__('H6', 'bixol'),
            'subtitle'    => esc_html__('This will be the default font for all H6 tags of your website.', 'bixol'),
            'google'      => true,
            'font-backup' => true,
            'all_styles'  => true,
            'text-align'  => false,
            'output'      => array('h6', '.h6'),
            'units'       => 'px',
            'required' => array( 0 => 'heading_default_font', 1 => 'equals', 2 => 'Google-Font' ),
            'force_output' => true
        ),
    )
));

Redux::setSection($opt_name, array(
    'title'      => esc_html__('Fonts Selectors', 'bixol'),
    'icon'       => 'el el-fontsize',
    'subsection' => true,
    'fields'     => array(
        array(
            'id'          => 'custom_font_1',
            'type'        => 'typography',
            'title'       => esc_html__('Custom Font', 'bixol'),
            'subtitle'    => esc_html__('This will be the font that applies to the class selector.', 'bixol'),
            'google'      => true,
            'font-backup' => true,
            'all_styles'  => true,
            'text-align'  => false,
            'output'      => $custom_font_selectors_1,
            'units'       => 'px',

        ),
        array(
            'id'       => 'custom_font_selectors_1',
            'type'     => 'textarea',
            'title'    => esc_html__('CSS Selectors', 'bixol'),
            'subtitle' => esc_html__('Add class selectors to apply above font.', 'bixol'),
            'validate' => 'no_html'
        )
    )
));

Redux::setSection($opt_name, array(
    'title'      => esc_html__('Extra Post Type', 'bixol'),
    'icon'       => 'el el-briefcase',
    'fields'     => array(
        array(
            'title' => esc_html__('Portfolio', 'bixol'),
            'type'  => 'section',
            'id' => 'post_portfolio',
            'indent' => true,
        ),
        array(
            'id'      => 'portfolio_slug',
            'type'    => 'text',
            'title'   => esc_html__('Portfolio Slug', 'bixol'),
            'default' => '',
            'desc'     => 'Default: portfolio',
        ),
        array(
            'id'      => 'portfolio_name',
            'type'    => 'text',
            'title'   => esc_html__('Portfolio Name', 'bixol'),
            'default' => '',
            'desc'     => 'Default: Portfolio',
        ),
        array(
            'id'      => 'portfolio_category_slug',
            'type'    => 'text',
            'title'   => esc_html__('Portfolio Category Slug', 'bixol'),
            'default' => '',
            'desc'     => 'Default: portfolio-category',
        ),
        array(
            'id'      => 'portfolio_category_name',
            'type'    => 'text',
            'title'   => esc_html__('Portfolio Category Name', 'bixol'),
            'default' => '',
            'desc'     => 'Default: Portfolio Categories',
        ),
        array(
            'id'    => 'archive_portfolio_link',
            'type'  => 'select',
            'title' => esc_html__( 'Custom Archive Page Link', 'bixol' ), 
            'data'  => 'page',
            'args'  => array(
                'post_type'      => 'page',
                'posts_per_page' => -1,
                'orderby'        => 'title',
                'order'          => 'ASC',
            ),
        ),
        array(
            'title' => esc_html__('Service', 'bixol'),
            'type'  => 'section',
            'id' => 'post_service',
            'indent' => true,
        ),
        array(
            'id'      => 'service_slug',
            'type'    => 'text',
            'title'   => esc_html__('Service Slug', 'bixol'),
            'default' => '',
            'desc'     => 'Default: service',
        ),
        array(
            'id'      => 'service_name',
            'type'    => 'text',
            'title'   => esc_html__('Service Name', 'bixol'),
            'default' => '',
            'desc'     => 'Default: Service',
        ),
        array(
            'id'      => 'service_category_slug',
            'type'    => 'text',
            'title'   => esc_html__('Service Category Slug', 'bixol'),
            'default' => '',
            'desc'     => 'Default: service-category',
        ),
        array(
            'id'      => 'service_category_name',
            'type'    => 'text',
            'title'   => esc_html__('Service Category Name', 'bixol'),
            'default' => '',
            'desc'     => 'Default: Service Categories',
        ),
        array(
            'id'    => 'archive_service_link',
            'type'  => 'select',
            'title' => esc_html__( 'Custom Archive Page Link', 'bixol' ), 
            'data'  => 'page',
            'args'  => array(
                'post_type'      => 'page',
                'posts_per_page' => -1,
                'orderby'        => 'title',
                'order'          => 'ASC',
            ),
        ),
    )
));

/* Google Maps /--------------------------------------------------------- */
Redux::setSection($opt_name, array(
    'title'  => esc_html__('Google Maps', 'bixol'),
    'icon'   => 'el el-map-marker',
    'fields' => array(
        array(
            'id'       => 'gm_api_key',
            'type'     => 'text',
            'title'    => esc_html__('API Key', 'bixol'),
            'default' => '',
            'desc' => esc_html__('Register a Google Maps Api key then put it in here.', 'bixol')
        ),
    ),
));

/* Custom Code /--------------------------------------------------------- */
Redux::setSection($opt_name, array(
    'title'  => esc_html__('Custom Code', 'bixol'),
    'icon'   => 'el-icon-edit',
    'fields' => array(

        array(
            'id'       => 'site_header_code',
            'type'     => 'textarea',
            'theme'    => 'chrome',
            'title'    => esc_html__('Header Custom Codes', 'bixol'),
            'subtitle' => esc_html__('It will insert the code to wp_head hook.', 'bixol'),
        ),
        array(
            'id'       => 'site_footer_code',
            'type'     => 'textarea',
            'theme'    => 'chrome',
            'title'    => esc_html__('Footer Custom Codes', 'bixol'),
            'subtitle' => esc_html__('It will insert the code to wp_footer hook.', 'bixol'),
        ),

    ),
));

/* Custom CSS /--------------------------------------------------------- */
Redux::setSection($opt_name, array(
    'title'  => esc_html__('Custom CSS', 'bixol'),
    'icon'   => 'el-icon-adjust-alt',
    'fields' => array(

        array(
            'id'   => 'customcss',
            'type' => 'info',
            'desc' => esc_html__('Custom CSS', 'bixol')
        ),

        array(
            'id'       => 'site_css',
            'type'     => 'ace_editor',
            'title'    => esc_html__('CSS Code', 'bixol'),
            'subtitle' => esc_html__('Advanced CSS Options. You can paste your custom CSS Code here.', 'bixol'),
            'mode'     => 'css',
            'validate' => 'css',
            'theme'    => 'chrome',
            'default'  => ""
        ),

    ),
));